package editor;

import game.CustomImageDataII;
import game.PonyPanel;

import java.awt.Color;
import java.awt.Point;
import java.io.File;

public class StaticBlockCanvasObjectFactory {
	
	private CustomImageDataII background;
	private CustomImageDataII foreground;
	
	private int tileWidth;
	private int tileHeight;
	
	private int blocksWide;
	private int blocksHigh;
	
	private String roomName;
	
	private String backgroundFileName;
	private String foregroundFileName;
	
	private Color unusedColor;
	private Color transparentColor;
	private Color outOfBoundsColor;
	
	
	public Point translateClickXYtoBlockXY(int clickX, int clickY) {
		Point returnValue = new Point();
		
		returnValue.x = clickX / tileWidth;
		returnValue.y = clickY / tileHeight;
		
		return returnValue;
	}
	
	public StaticBlockCanvasObjectFactory(NewRoomData wizard, EditorCanvas canvas) {
		
		tileWidth = wizard.getTileWidth();
		tileHeight = wizard.getTileHeight();
		
		roomName = wizard.getRoomName();
		
		blocksWide = wizard.getRoomWidth();
		blocksHigh = wizard.getRoomHeight();

		background = new CustomImageDataII(new File(wizard.getBackgroundImageName()), null, canvas, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
		foreground = new CustomImageDataII(new File(wizard.getForegroundImageName()), wizard.getTransparentColor(), canvas, tileWidth * blocksWide, tileHeight * blocksHigh);
		
		backgroundFileName = wizard.getBackgroundImageName();
		foregroundFileName = wizard.getForegroundImageName();
		
		unusedColor = wizard.getUnusedColor();
		transparentColor = wizard.getTransparentColor();
		outOfBoundsColor = wizard.getOutOfBoundsColor();
		
	}
	
	
	
	public StaticBlockCanvasObjectFactory(NewRoomSetupWizard wizard, EditorCanvas canvas, boolean shouldAvoidChangingDimensions, int existingBlocksWide, int existingBlocksHigh) {
		
		tileWidth = wizard.getTileWidth();
		tileHeight = wizard.getTileHeight();
		
		roomName = wizard.getRoomName();
		
		if(shouldAvoidChangingDimensions) {
			
			background = new CustomImageDataII(new File(wizard.getBackgroundImageName()), null, canvas, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
			foreground = new CustomImageDataII(new File(wizard.getForegroundImageName()), wizard.getTransparentColor(), canvas, tileWidth * existingBlocksWide, tileHeight * existingBlocksHigh);
			
			blocksWide = existingBlocksWide;
			blocksHigh = existingBlocksHigh;
	
			
		} else {
		
			blocksWide = wizard.getRoomWidth();
			blocksHigh = wizard.getRoomHeight();
	
			background = new CustomImageDataII(new File(wizard.getBackgroundImageName()), null, canvas, PonyPanel.PLAY_AREA_WIDTH, PonyPanel.PANEL_HEIGHT);
			foreground = new CustomImageDataII(new File(wizard.getForegroundImageName()), wizard.getTransparentColor(), canvas, tileWidth * blocksWide, tileHeight * blocksHigh);
			
		}
		
		backgroundFileName = wizard.getBackgroundImageName();
		foregroundFileName = wizard.getForegroundImageName();
		
		unusedColor = wizard.getUnusedColor();
		transparentColor = wizard.getTransparentColor();
		outOfBoundsColor = wizard.getOutOfBoundsColor();
		
	}

	public CustomImageDataII getBackground() {
		return background;
	}

	public CustomImageDataII getForeground() {
		return foreground;
	}

	public int getTileWidth() {
		return tileWidth;
	}

	public int getTileHeight() {
		return tileHeight;
	}

	public int getBlocksWide() {
		return blocksWide;
	}

	public int getBlocksHigh() {
		return blocksHigh;
	}

	public String getRoomName() {
		return roomName;
	}

	public String getBackgroundFileName() {
		return backgroundFileName;
	}

	public String getForegroundFileName() {
		return foregroundFileName;
	}

	public Color getUnusedColor() {
		return unusedColor;
	}

	public Color getTransparentColor() {
		return transparentColor;
	}

	public Color getOutOfBoundsColor() {
		return outOfBoundsColor;
	}
	
	public void setRoomName(String newRoomName) {
		roomName = newRoomName;
	}
	
	
}
